/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.sales.controller;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.sales.model.Vat;
import itx.erp.sales.service.ArticleService;
import itx.erp.sales.validator.VatValidator;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import jtbcore.exception.JTBException;
import jtbcore.util.NumberUtil;

public class VatController
extends BaseController {
    protected ArticleService articleService;

    public ArticleService getArticleService() {
        return this.articleService;
    }

    public void setArticleService(ArticleService articleService) {
        this.articleService = articleService;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        this.executeAction(webRequest);
    }

    public void indexAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        List<Vat> vats = this.articleService.readVats();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("vats", vats);
        result.put("success", true);
        req.renderJson(result);
    }

    public void deleteAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        Integer vatId = req.getParamInt("vatId");
        HashMap<String, Object> result = new HashMap<String, Object>();
        Integer cnt = this.articleService.vatUseCount(vatId);
        if (cnt == 0) {
            this.articleService.deleteVat(vatId);
            result.put("success", true);
        } else {
            result.put("success", true);
            result.put("message", "Btw tarief nog in gebruik door " + String.valueOf(cnt) + " artikel(en)");
        }
        req.renderJson(result);
    }

    public void viewAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        Integer vatId = req.getParamInt("vatId");
        Vat vat = this.articleService.readVat(vatId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("vat", vat);
        result.put("success", true);
        req.renderJson(result);
    }

    public void saveAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        Integer vatId = req.getParamInt("vatId");
        Vat vat = vatId != null ? this.articleService.readVat(vatId) : new Vat();
        vat.setDescription(req.getParameter("description"));
        vat.setPercentage(req.getParamDouble("percentage"));
        vat.setVisible(req.getParamBool("visible"));
        vat.setDefaultSelected(req.getParamBool("defaultSelected"));
        HashMap<String, Object> result = new HashMap<String, Object>();
        VatValidator v = new VatValidator();
        if (v.validate(vat)) {
            vatId = this.articleService.saveVat(vat);
            result.put("success", true);
            result.put("vatId", vatId);
        } else {
            result.put("error", true);
            result.put("errors", v.getErrors());
        }
        req.renderJson(result);
    }

    public void updateSortAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        List<Integer> l = NumberUtil.csl2int(req.getParameter("ids"));
        this.articleService.updateVatSort(l);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }
}

